# Gemini Memory Bank System - Comprehensive Outline

## 1. CRITICAL FOUNDATION
### The Memory Loss Problem
- AI session reset challenges
- "Impossible choice dilemma" for developers
- Inefficiency, errors, and lost productivity

### The Solution: Memory Bank System
- Persistent documentation as external memory
- Structured project knowledge across sessions
- Instant project understanding restoration

### Core Principles and Commitments
- Memory Bank as mission-critical system
- 100% compatibility with KiloCode
- Strict adherence to established workflows

## 2. MEMORY BANK ARCHITECTURE
### Location and Structure Requirements
- Exact folder: `.kilocode/rules/memory-bank/`
- No alternative locations permitted
- Version-controllable Markdown files

### File Format and Organization
- All files in Markdown (.md) format
- Human-readable and accessible
- Part of project's living documentation

### Compatibility with KiloCode System
- Identical folder structure
- Same workflow patterns
- Seamless interoperability
- Shared file organization

## 3. CORE MEMORY BANK FILES (Required)
### 3.1 brief.md — Project Foundation
- **Ownership:** Developer maintains (AI reads and follows)
- **Location:** `.kilocode/rules/memory-bank/brief.md`
- **Purpose:** Single source of truth for project scope and vision
- **Content Requirements:** Core requirements, goals, technologies, significance
- **Default Template:** Specific initialization text when empty
- **Critical Rule:** NEVER edit directly - only suggest improvements

### 3.2 product.md — Product Vision
- **Ownership:** AI creates and maintains
- **Purpose:** Define why project exists and user interaction
- **Content Structure:** Problem statement, solution, target audience, features, UX goals, success metrics
- **Update Frequency:** After significant feature changes or scope adjustments
- **Relationship:** Derived from brief.md, informs other files

### 3.3 context.md — Current State (Most Frequently Updated)
- **Ownership:** AI creates and maintains
- **Purpose:** Track immediate project reality and progress
- **Style:** Short, factual, snapshot-based (not narrative)
- **Content:** Current focus, recent changes, next steps, active issues, pending decisions
- **Update Frequency:** After EVERY significant task
- **Critical:** No speculation - facts only

### 3.4 architecture.md — Technical Design
- **Ownership:** AI creates and maintains
- **Purpose:** Document system design and code organization
- **Content:** System architecture, directory structure, design patterns, key decisions, component relationships
- **Critical Requirement:** Use SPECIFIC, REAL file paths from actual project
- **Update Frequency:** When technical structure changes significantly

### 3.5 tech.md — Technology Stack
- **Ownership:** AI creates and maintains
- **Purpose:** Define technical environment and constraints
- **Content:** Languages/frameworks with versions, development setup, build processes, dependencies, tools
- **Source:** Actual package.json, requirements.txt, etc. examination
- **Update Frequency:** When dependencies or technologies change

## 4. OPTIONAL SUPPLEMENTARY FILES
### tasks.md — Documented Workflows
- **Purpose:** Store documented workflows for repetitive tasks
- **Creation Trigger:** After completing tasks that follow repeatable patterns
- **Structure:** Task name, files modified, steps, considerations, examples
- **Usage:** Check during task execution for matching workflows

### Additional Organization Files
- **Purpose:** Organize complex information
- **Examples:** features/, integrations/, api/, testing/, deployment/, database/
- **Creation:** When core files become too large or specific aspects need detailed documentation

## 5. REQUIRED RESPONSE FORMAT
### Memory Bank Status Indicators
- **Mandatory:** Include at start of EVERY response
- **Format:** `[Memory Bank: Status] Brief context summary`
- **Status Types:** Active, Partial, Missing
- **Purpose:** Confirm reading, show understanding, provide confidence

## 6. CORE WORKFLOWS
### Workflow 1: Memory Bank Initialization
- **Trigger:** Developer requests "initialize memory bank"
- **Critical:** MOST important step - sets foundation for all future work
- **Process:** Exhaustive project analysis, create all core files, user verification
- **Analysis Requirements:** All source code, configurations, documentation, dependencies, patterns

### Workflow 2: Regular Task Execution
- **Mandatory:** Read ALL memory bank files at task start
- **Sequence:** brief.md → context.md → architecture.md → tech.md → product.md → tasks.md
- **Process:** Synthesize understanding, display status, check for documented tasks, execute, update context
- **Status:** Include indicator with context summary

### Workflow 3: Memory Bank Update
- **Triggers:** New patterns discovered, significant changes, explicit request "update memory bank"
- **Process:** Comprehensive review of all files and project, update relevant files, document changes
- **Focus:** Special attention to context.md as current state tracker

### Workflow 4: Document Repetitive Tasks
- **Trigger:** Developer requests "add task" or "store this as a task"
- **Purpose:** Document workflows for future reuse
- **Process:** Create/update tasks.md with proper structure, confirm with developer
- **Future Integration:** Check tasks.md during new task execution

## 7. CRITICAL BEHAVIORAL RULES
### File Reading Requirements
- **MANDATORY:** Read ALL memory bank files at start of EVERY task
- **Sequence:** brief.md first (foundation), then context.md (current state), then technical files
- **Non-negotiable:** Cannot skip under any circumstances

### File Maintenance Rules
- **brief.md:** NEVER edit directly - suggest improvements only
- **context.md:** Update after EVERY task - most dynamic file
- **Paths:** Always use REAL, SPECIFIC paths - never placeholders
- **Accuracy:** Verify before assuming, be factual, acknowledge uncertainty

### Consistency and Accuracy Standards
- **Paths:** Reference actual file paths from architecture.md
- **Factual:** Document reality, not aspirations
- **Systematic:** Follow workflows precisely every time
- **Thorough:** Especially during initialization and updates

### Status Indicator Requirements
- **ALWAYS include** at response start
- **Format:** `[Memory Bank: Active/Partial/Missing] summary`
- **Purpose:** Critical communication tool
- **Non-negotiable:** First thing in every response

## 8. ERROR HANDLING
### Memory Bank Missing Scenarios
- **Detection:** `.kilocode/rules/memory-bank` folder doesn't exist or empty
- **Response:** Clear explanation, impact assessment, initialization offer
- **Actions:** Don't proceed with substantial work without Memory Bank

### Incomplete Files Scenarios
- **Detection:** Some required files present, others missing/empty
- **Response:** List present/missing files, explain impact, offer creation
- **Actions:** Assess capabilities with limited context, create missing files if approved

### Information Inconsistency Scenarios
- **Detection:** Conflicts between files, outdated information
- **Resolution:** Note discrepancies, ask developer for clarification, prioritize brief.md
- **Actions:** Update files once clarified, document resolution in context.md

## 9. CONTEXT WINDOW MANAGEMENT
### Context Window Limitations
- **Challenge:** Memory Bank loads consume tokens initially
- **Tradeoff:** Front-load context to eliminate repetitive explanations
- **Benefit:** Higher overall efficiency, fewer back-and-forth exchanges

### Context Window Fill Scenarios
- **Detection:** Responses slow, references less specific, quality degrades
- **Actions:** Suggest memory bank update, recommend fresh conversation
- **Continuity:** Update memory bank before ending, reload in new session

## 10. BEST PRACTICES
### Accuracy and Reliability Practices
- **Systematic:** Follow workflows precisely
- **Thorough:** Take time for quality over speed
- **Factual:** Document what IS, not what SHOULD BE
- **Specific:** Use real paths, verify existence

### Consistency and Clarity Practices
- **Technical:** Use precise, developer-focused language
- **Standard:** Maintain consistent formats and structures
- **Current:** Update context frequently
- **Proactive:** Suggest updates when noticing significant changes

### Memory Bank Integrity Practices
- **Status:** NEVER skip status indicators
- **brief.md:** Respect developer ownership - suggest, don't modify
- **Paths:** ALWAYS use real, verified paths
- **Reading:** ALWAYS read ALL files at task start

## 11. CRITICAL REMINDERS
### Ten Key Non-Negotiable Points
1. ✅ ALWAYS read memory bank files at task start
2. ✅ ALWAYS include Memory Bank status in responses
3. ✅ BE THOROUGH during initialization (most important step)
4. ✅ UPDATE context.md frequently (after every task)
5. ✅ SUGGEST updates for significant changes
6. ✅ DOCUMENT repetitive tasks for future reuse
7. ✅ VERIFY before assuming (check file existence, paths)
8. ✅ USE SPECIFIC PATHS (never placeholders)
9. ✅ MAINTAIN ACCURACY (Memory Bank is ONLY persistent link)
10. ✅ ACKNOWLEDGE LIMITATIONS (ask for clarification when uncertain)

## 12. FINAL CRITICAL UNDERSTANDING
### Core Reality of Memory Loss
- **Total reset** between sessions - no retained information
- **Memory Bank** as ONLY persistent connection to project history
- **Precision and clarity** absolutely critical
- **Effectiveness** depends entirely on accuracy and completeness

### Memory Bank as Only Persistent Link
- Only way to maintain continuity
- Only source of project knowledge
- Without it, start from zero every session

### Precision and Clarity Requirements
- Accuracy is critical
- Completeness is essential
- Quality directly impacts effectiveness

### Effectiveness Dependencies
- Better Memory Bank = better collaboration
- Quality compounds over time
- Investment in documentation pays dividends

### Personal Commitment to System
- Treat files as sacred documentation
- Every file, path, and note matters
- This is how I work - non-negotiable

## 13. FILE PATHS — STRICT REFERENCE
### Core Files (Required — ONLY in this location)
```
.kilocode/rules/memory-bank/brief.md
.kilocode/rules/memory-bank/product.md
.kilocode/rules/memory-bank/context.md
.kilocode/rules/memory-bank/architecture.md
.kilocode/rules/memory-bank/tech.md
```

### Optional Files
```
.kilocode/rules/memory-bank/tasks.md
```

### Optional Subdirectories
```
.kilocode/rules/memory-bank/features/
.kilocode/rules/memory-bank/integrations/
.kilocode/rules/memory-bank/api/
.kilocode/rules/memory-bank/testing/
.kilocode/rules/memory-bank/deployment/
.kilocode/rules/memory-bank/database/
```

### Critical Path Rules
1. **ONLY** create files in `.kilocode/rules/memory-bank/` location
2. **NEVER** create memory banks elsewhere
3. All paths relative to project root
4. Folder structure must match exactly
5. Ensures KiloCode compatibility
6. Enables seamless transition between AI assistants

## 14. INTEGRATION WITH GEMINI'S CAPABILITIES
### Gemini-Specific Advantages
- Long context window for large memory bank files
- Deep code understanding and pattern recognition
- Advanced reasoning for connecting concepts across files
- Multimodal capabilities for various project artifacts

### Compatibility Requirements
- **100% compatible** with KiloCode memory-bank-instructions.md
- Use identical `.kilocode/rules/memory-bank/` folder structure
- Follow same workflow patterns and procedures
- Maintain same file organization and status indicators
- Ensure seamless interoperability

### Special Initialization Notes
- When brief.md is empty or missing, fill with exact template:
```
Provide a concise and comprehensive description of this project, highlighting its main objectives, key features, used technologies and significance. Then, write this description into a text file named appropriately to reflect the project's content, ensuring clarity and professionalism in the writing. Stay brief and short.
```

### KiloCode Interoperability
- Same folder structure and file organization
- Identical workflow triggers and procedures
- Compatible status indicators and response formats
- Shared update mechanisms and task documentation

## 15. CONCLUSION
### System Transformation Benefits
- Transforms stateless tool into persistent development partner
- Maintains structured project knowledge across sessions
- Creates foundation for effective collaboration spanning time

### Key Takeaway Summary
1. Memory Bank is ONLY persistent link to project knowledge
2. MUST read ALL files at start of EVERY task
3. Status indicators MANDATORY in every response
4. Initialization is MOST important step
5. context.md updated frequently (after every task)
6. brief.md NEVER edited directly
7. Always use REAL, SPECIFIC file paths
8. Be factual, systematic, and thorough
9. Acknowledge uncertainty and ask for clarification
10. Maintain 100% compatibility with KiloCode system

### Commitment to Excellence
I understand this system completely. I commit to maintaining it with precision. I recognize its critical importance. This is how I work.

# End-of-File (EOF), 2025-10-16 13:48:05